#ifndef BINARY_SEARCH_TREE_H
#define BINARY_SEARCH_TREE_H

#include "Binary_Tree.h"

template<class Type>
class BinarySearchTree : public BinaryTree<Type>
{
public:
	//Insert a node at the correct location
	bool insert(const Type&);

	//Remove the node if Found
	bool remove(const Type&);

	//Find target Node
	bool getEntry(const Type&, Type&) const;


private:
	//Internal Insert Node
	BinaryNode<Type>* _insert(BinaryNode<Type>*, BinaryNode<Type>*);
	
	//Internal Remove Node
	BinaryNode<Type>* _remove(BinaryNode<Type>*, const Type&, bool&);

	//Delete Target Node from Tree, called by internal remove Node
	BinaryNode<Type>* deleteNode(BinaryNode<Type>*);

	//Remove leftmost Node in tree
	BinaryNode<Type>* removeLeftmostNode(BinaryNode<Type>*, Type&);

	//Search for target Node
	BinaryNode<Type>* findNode(BinaryNode<Type>*, const Type&) const;
};

#endif